unit CustomRar;

(*
  TUnrar for Kylix ( tested on Kylix3 ) for libunrar.so
  libunrar.so "translated" from unrar.dll by le_barbu.
  libunrar.so Released under rarlab licence (see <www.rarlab.com>).
  TUnrar released under GNU/GPL licence.
  eMail:  le.barbu.li@free.fr
*)

interface

uses SysUtils, Classes, Libc;

const
  //Constants from original libunrar.so
  ERAR_END_ARCHIVE    = 10;
  ERAR_NO_MEMORY      = 11;
  ERAR_BAD_DATA       = 12;
  ERAR_BAD_ARCHIVE    = 13;
  ERAR_UNKNOWN_FORMAT = 14;
  ERAR_EOPEN          = 15;
  ERAR_ECREATE        = 16;
  ERAR_ECLOSE         = 17;
  ERAR_EREAD          = 18;
  ERAR_EWRITE         = 19;
  ERAR_SMALL_BUF      = 20;
  ERAR_UNKNOWN        = 21;

  RAR_OM_LIST         = 0;
  RAR_OM_EXTRACT      = 1;

  RAR_SKIP            = 0;
  RAR_TEST            = 1;
  RAR_EXTRACT         = 2;

  RAR_VOL_ASK         = 0;
  RAR_VOL_NOTIFY      = 1;

  UCM_CHANGEVOLUME    = 0;
  UCM_PROCESSDATA     = 1;
  UCM_NEEDPASSWORD    = 2;

  // usefull constants. Not defined in libunrar.so !
  RAR_DLL             = 'libunrar.so';
  ERAR_NO_DLL         = -1;
  RAR_UNSUCCESS       = -1;

  //defined in TDFUnRar for Delphi **Copyright (C) 2003 by Dirk Frischalowski, All rights reserved. eMail: dfrischalowski@del-net.com**
  //see www.rarlab.com

  RAR_METHOD_STORE    = 48;
  RAR_METHOD_FASTEST  = 49;
  RAR_METHOD_FAST     = 50;
  RAR_METHOD_NORMAL   = 51;
  RAR_METHOD_GOOD     = 52;
  RAR_METHOD_BEST     = 53;

  RAR_SUCCESS        = 0;
  
  {RAR_COMMENTS_EXISTS= 1;
  RAR_NO_COMMENTS    = 0;}

  MAXRARCOMMENTSIZE  = 1024 * 64; // 64kB

type

  RARHeaderData       = record
    ArcName   : array[0..259] of Char;
    FileName  : array[0..259] of Char;
    Flags     : Cardinal;
    PackSize  : Cardinal;
    UnpSize   : Cardinal;
    HostOS    : Cardinal;
    FileCRC   : Cardinal;
    FileTime  : Cardinal;
    UnpVer    : Cardinal;
    Method    : Cardinal;
    FileAttr  : Cardinal;
    CmtBuf    : PChar;
    CmtBufSize: Cardinal;
    CmtSize   : Cardinal;
    CmtState  : Cardinal;
  end;
  PRARHeaderData      = ^RARHeaderData;

  (* not used here
  TRARHeaderDataEx    = record
    ArcName   : array[0..1023] of Char;
    ArcNameW  : array[0..1023] of wchar_t;
    FileName  : array[0..1023] of Char;
    FileNameW : array[0..1023] of wchar_t;
    Flags     : Cardinal;
    PackSize  : Cardinal;
    PackSizeHigh:Cardinal;
    UnpSize   : Cardinal;
    UnpSizeHigh:Cardinal;
    HostOS    : Cardinal;
    FileCRC   : Cardinal;
    FileTime  : Cardinal;
    UnpVer    : Cardinal;
    Method    : Cardinal;
    FileAttr  : Cardinal;
    CmtBuf    : PChar;
    CmtBufSize: Cardinal;
    CmtSize   : Cardinal;
    CmtState  : Cardinal;
    Reserved  : array[0..1023] of Cardinal;
  end;
  PRARHeaderDataEx  = ^RARHeaderDataEx;
  *)

  RAROpenArchiveData  = record
    ArcName   : PChar;
    OpenMode  : Cardinal;
    OpenResult: Cardinal;
    CmtBuf    : PChar;
    CmtBufSize: Cardinal;
    CmtSize   : Cardinal;
    CmtState  : Cardinal;
  end;
  PRAROpenArchiveData = ^RAROpenArchiveData;

  (* not used here
  RAROpenArchiveDataEx= record
    ArcName   : PChar;
    ArcNameW  : PChar;
    OpenMode  : Cardinal;
    OpenResult: Cardinal;
    CmtBuf    : PChar;
    CmtBufSize: Cardinal;
    CmtSize   : Cardinal;
    CmtState  : Cardinal;
    Flags     : Cardinal;
    Reserved  : array[0..31] of Cardinal;
  end;
  PRAROpenArchiveDataEx = ^RAROpenArchiveDataEx;
  *)

  //function pointers, use TUnrarCallback, the last 2 are deprecated;
  TUnrarCallback      = function(msg:Cardinal; UserData, P1, P2: Longint): Integer;  cdecl;
  TChangeVolProc      = function(ArcName:PChar; Mode: Integer): Integer;  stdcall;
  TProcessDataProc    = function(Addr:PByte; Size:Integer): Integer;  stdcall;

  //libunrar.so API
  TRAROpenArchive     = function(ArchiveData:PRAROpenArchiveData):  THandle; cdecl;
  (* not used here
  TRAROpenArchiveEx   = function(ArchiveData:PRAROpenArchiveDataEx):  THandle;  cdecl;
  *)
  TRARCloseArchive    = function(hArcData:THandle): Integer;  cdecl;
  TRARReadHeader      = function(hArcData:THandle; HeaderData:PRARHeaderData):  Integer;  cdecl;
  (* not used here
  TRARReadHeaderEx    = function(hArcData:THandle; HeaderData:PRARHeaderDataEx):  Integer;  cdecl;
  *)
  TRARProcessFile     = function(hArcData:THandle; Operation:Integer; DestPath, DestName:PChar):  Integer;  cdecl;
  (* not used here
  TRARProcessFileW    = function(hArcData:THandle; Operation:Integer; DestPath, DestName:Pwchar_t): Integer;  cdecl;
  *)
  TRARSetCallback     = procedure(hArcData:THandle; Callback:TUnrarCallback; UserData:Longint); cdecl;

  TRARSetChangeVolProc= procedure(hArcData:THandle; ChangeVolProc:TChangeVolProc);  cdecl;
  TRARSetProcessDataProc= procedure(hArcData:THandle; ProcessDataProc:TProcessDataProc);  cdecl;

  TRARSetPassword     = procedure(hArcData:THandle; Password:PChar);  cdecl;
  TRARGetDllVersion   = function: Integer;  cdecl;

  RAR_Exception       = class
    codeError:  Integer;
  end;

var
  
  RAROpenArchive:TRAROpenArchive;
  RARCloseArchive:TRARCloseArchive;
  RARReadHeader:TRARReadHeader;
  RARProcessFile:TRARProcessFile;
  RARSetCallback:TRARSetCallback;
  RARSetChangeVolProc:TRARSetChangeVolProc;
  RARSetProcessDataProc:TRARSetProcessDataProc;
  RARSetPassword:TRARSetPassword;
  RARGetDllVersion:TRARGetDllVersion;

ResourceString
  // For Messages
  MSG_ECLOSE        = 'Error while closing file';
  MSG_EPWD          = 'Wrong password';
  MSG_EDLL          = 'Unable to load libunrar.so';
  MSG_ECORRUPT      = 'Data corrupt';
  MSG_EARCHIVE      = 'Bad archive';
  MSG_EUNKNOWN      = 'Unknown archive';
  MSG_EVOLUME       = 'Wrong volume';
  MSG_ECREAT        = 'Error while creating file';
  MSG_EREAD         = 'Error while reading file';
  MSG_EOPEN         = 'Error while opening file';
  MSG_EWRITE        = 'Error while writing file';
  MSG_EMEMORY       = 'Memory error';
  MSG_EBUFFER       = 'Buffer too small';
  MSG_EHEAD         = 'Header corrupted';
  // For Dialogs
  DLG_VOL_LABEL     = 'Please change volume';
  DLG_PWD_LABEL     = 'Please enter password';
  DLG_OVER_LABEL    = 'Overwrite file?';
  DLG_CANCEL        = 'Cancel';
  DLG_OK            = 'Ok';
  DLG_VOL_TITLE     = 'Change volume';
  DLG_PWD_TITLE     = 'Password';
  DLG_OVER_TITLE    = 'Overwrite file';
  DLG_OVER_ALL      = 'All';
  DLG_OVER_NONE     = 'None';
  DLG_OVER_YES      = 'Yes';
  DLG_OVER_NO       = 'Skip';
  DLG_PWD_SAMEFORALL= 'Same password for all files';
  // Compress Methods
  COMPRESSMETHODSTORE   = 'store';
  COMPRESSMETHODFASTEST = 'fastest';
  COMPRESSMETHODFAST    = 'fast';
  COMPRESSMETHODNORMAL  = 'normal';
  COMPRESSMETHODGOOD    = 'better';
  COMPRESSMETHODBEST    = 'best';

var
  IsLoaded:Boolean =false;

procedure LoadLib;
procedure FreeLib;

implementation

var
  RARHandler:Pointer;

procedure LoadLib;
begin
  RARHandler:=dlopen(RAR_DLL, RTLD_LAZY);
  if RARHandler=nil then
    IsLoaded:=false
  else begin
    IsLoaded:=true;
    @RAROpenArchive:=dlsym(RARHandler, 'RAROpenArchive');
    @RARCloseArchive:=dlsym(RARHandler, 'RARCloseArchive');
    @RARReadHeader:=dlsym(RARHandler, 'RARReadHeader');
    @RARProcessFile:=dlsym(RARHandler, 'RARProcessFile');
    @RARSetCallback:=dlsym(RARHandler, 'RARSetCallback');
    @RARSetChangeVolProc:=dlsym(RARHandler, 'RARSetChangeVolProc');
    @RARSetProcessDataProc:=dlsym(RARHandler, 'RARSetProcessDataProc');
    @RARSetPassword:=dlsym(RARHandler, 'RARSetPassword');
    @RARGetDllVersion:=dlsym(RARHandler, 'RARGetDllVersion');
  end;
end;

procedure FreeLib;
begin
  dlclose(RARHandler);
  RARHandler:=nil;
  RAROpenArchive:=nil;
  RARCloseArchive:=nil;
  RARReadHeader:=nil;
  RARProcessFile:=nil;
  RARSetCallback:=nil;
  RARSetChangeVolProc:=nil;
  RARSetProcessDataProc:=nil;
  RARSetPassword:=nil;
  RARGetDllVersion:=nil;
  IsLoaded:=false;
end;

end.
